/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.Paths;
import net.nooj4nlp.engine.helper.ParameterCheck;
import net.nooj4nlp.gui.main.Launcher;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class Utilities {
    private static final String BACKUP_FOLDER_NAME = "Backup";
    private static final String PREFERENCES_NOJ_FILE_NAME = "Preferences.jnoj";
    private static final String PROJECTS_FOLDER_NAME = "Projects";
    private static final String SYNTACTIC_ANALYSIS_FOLDER_NAME = "Syntactic Analysis";
    private static final String LEXICAL_ANALYSIS_FOLDER_NAME = "Lexical Analysis";

    private static void xcopy(String sourceDirPath, String targetDirPath, boolean onlyUnderlinedFiles) throws IOException {
        ParameterCheck.mandatoryString("sourceDirPath", sourceDirPath);
        ParameterCheck.mandatoryString("targetDirPath", targetDirPath);
        if (sourceDirPath.equals(targetDirPath)) {
            return;
        }
        File sourceDir = new File(sourceDirPath);
        if (!sourceDir.isDirectory()) {
            throw new IOException("SourceDir on path '" + sourceDirPath + "' exists but is not a directory");
        }
        File targetDir = new File(targetDirPath);
        if (!targetDir.isDirectory()) {
            targetDir.mkdir();
        }
        if (onlyUnderlinedFiles) {
            for (File file : targetDir.listFiles()) {
                String fileName;
                if (!file.isFile() || (fileName = file.getName()).length() <= 1 || fileName.charAt(0) != '_') continue;
                file.delete();
            }
        }
        for (File sourceFile : sourceDir.listFiles()) {
            String sourceName = sourceFile.getName();
            File targetFile = new File(targetDir, sourceName);
            if (sourceFile.isFile()) {
                if (targetFile.isFile()) {
                    if (onlyUnderlinedFiles && (sourceName.length() <= 1 || sourceName.charAt(0) != '_')) continue;
                    FileUtils.copyFile(sourceFile, targetFile);
                    continue;
                }
                FileUtils.copyFile(sourceFile, targetFile);
                continue;
            }
            if (!sourceFile.isDirectory()) continue;
            Utilities.xcopy(sourceFile.getPath(), targetFile.getPath(), onlyUnderlinedFiles);
        }
    }

    public static void initAllDiskResources() throws IOException {
        try {
            if (Launcher.class.getResource("Launcher.class").toString().startsWith("jar")) {
                ZipFile z = new ZipFile(Launcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                Enumeration<? extends ZipEntry> entries = z.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith("initial/") || entry.getName().equals("initial/")) continue;
                    String entryName = entry.getName().substring(entry.getName().indexOf(47) + 1);
                    if (entryName.contains("Projects(java)")) {
                        entryName = entryName.replace("Projects(java)", PROJECTS_FOLDER_NAME);
                    }
                    File f = new File(FilenameUtils.concat(Paths.docDir, entryName));
                    if (entry.isDirectory()) {
                        f.mkdir();
                        continue;
                    }
                    if (entryName.equals(PREFERENCES_NOJ_FILE_NAME)) {
                        if (f.exists()) continue;
                        Utilities.copyFromJar(entry.getName(), f);
                        continue;
                    }
                    Utilities.copyFromJar(entry.getName(), f);
                }
            } else {
                String appDirPath = FilenameUtils.concat(FilenameUtils.concat(Paths.applicationDir, "resources"), "initial");
                String docDirPath = Paths.docDir;
                File appDir = new File(appDirPath);
                if (!appDir.isDirectory()) {
                    throw new IOException("AppDir on path '" + appDirPath + "' exists but is not a directory");
                }
                File docDir = new File(docDirPath);
                if (!docDir.isDirectory()) {
                    throw new IOException("DocDir on path '" + docDirPath + "' exists but is not a directory");
                }
                for (File langDir : appDir.listFiles()) {
                    File docProjects;
                    File docSyntacticAnalysis;
                    File docLexicalAnalysis;
                    File docLangDir;
                    File projects;
                    File syntacticAnalysis;
                    String langDirName;
                    if (!langDir.isDirectory() || (langDirName = langDir.getName()).charAt(0) == '_' || !Language.isALanguage(langDirName)) continue;
                    File lexicalAnalysis = new File(langDir, LEXICAL_ANALYSIS_FOLDER_NAME);
                    if (!lexicalAnalysis.isDirectory()) {
                        lexicalAnalysis.mkdir();
                    }
                    if (!(syntacticAnalysis = new File(langDir, SYNTACTIC_ANALYSIS_FOLDER_NAME)).isDirectory()) {
                        syntacticAnalysis.mkdir();
                    }
                    if (!(projects = new File(langDir, "Projects(java)")).isDirectory()) {
                        projects.mkdir();
                    }
                    if (!(docLangDir = new File(docDir, langDirName)).isDirectory()) {
                        docLangDir.mkdir();
                    }
                    if (!(docLexicalAnalysis = new File(docLangDir, LEXICAL_ANALYSIS_FOLDER_NAME)).isDirectory()) {
                        docLexicalAnalysis.mkdir();
                    }
                    if (!(docSyntacticAnalysis = new File(docLangDir, SYNTACTIC_ANALYSIS_FOLDER_NAME)).isDirectory()) {
                        docSyntacticAnalysis.mkdir();
                    }
                    if (!(docProjects = new File(docLangDir, PROJECTS_FOLDER_NAME)).isDirectory()) {
                        docProjects.mkdir();
                    }
                    Utilities.xcopy(lexicalAnalysis.getPath(), docLexicalAnalysis.getPath(), true);
                    Utilities.xcopy(syntacticAnalysis.getPath(), docSyntacticAnalysis.getPath(), true);
                    Utilities.xcopy(projects.getPath(), docProjects.getPath(), true);
                }
                File appPreferenceFile = new File(appDir, PREFERENCES_NOJ_FILE_NAME);
                File docPreferenceFile = new File(docDir, PREFERENCES_NOJ_FILE_NAME);
                if (!docPreferenceFile.isFile()) {
                    FileUtils.copyFile(appPreferenceFile, docPreferenceFile);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean copyFromJar(String sResource, File fDest) {
        if (sResource == null || fDest == null) {
            return false;
        }
        InputStream sIn = null;
        OutputStream sOut = null;
        File sFile = null;
        try {
            sFile = new File(sResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int nLen = 0;
            sIn = Launcher.class.getClassLoader().getResourceAsStream(sResource);
            if (sIn == null) {
                throw new IOException("Error copying from jar(" + sResource + " to " + fDest.getPath() + ")");
            }
            sOut = new FileOutputStream(fDest);
            byte[] bBuffer = new byte[1024];
            while ((nLen = sIn.read(bBuffer)) > 0) {
                sOut.write(bBuffer, 0, nLen);
            }
            sOut.flush();
            try {
                if (sIn != null) {
                    sIn.close();
                }
                if (sOut != null) {
                    sOut.close();
                }
            }
            catch (IOException eError) {
                eError.printStackTrace();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            if (sIn != null) {
                sIn.close();
            }
        }
        catch (IOException eError) {
            eError.printStackTrace();
        }
        try {
            if (sOut != null) {
                sOut.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fDest.exists();
    }
}

